// Despiece para medida 3.00 x 2.50 x 2.50 M

const despiece_3x2_5x2_5 = {
    'SC': {
        nombre: 'Stand en Cajon',
        componentes: {
            'POSTES_2500': 10,
            'POSTES_300_ANTEPECHO': 1,
            'LARGUERO_950': 14,
            'LARGUERO_1940_ANTEPECHO': 2,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 7,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO1': 4,
            'MAMPARA_ANTEPECHO_469X214_1': 2,
            'LARGUERO_ANTEPECHO_2930': 2,
            'LARGUERO_455': 4,
            'MAMPARA_469X2390': 2,
            'LARGUERO_455_ANTEPECHO2': 0, 
            'MAMPARA_ANTEPECHO_469X214_2': 0,
            'LARGUERO_2435_ANTEPECHO': 0,
            'PANEL_ANTEPECHO_2449X214': 0,
            'LARGUERO_2435_INTERMERDIO': 0,
        }
    },
    'SE': {
        nombre: 'Stand en Esquina',
        componentes: {
            'POSTES_2500': 8,
            'POSTES_300_ANTEPECHO': 2,
            'LARGUERO_950': 10,
            'LARGUERO_1940_ANTEPECHO': 4,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 5,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 2,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO1': 4,
            'MAMPARA_ANTEPECHO_469X214_1': 2,
            'LARGUERO_ANTEPECHO_2930': 2,
            'LARGUERO_455': 2,
            'MAMPARA_469X2390': 1,
            'LARGUERO_455_ANTEPECHO2': 2, 
            'MAMPARA_ANTEPECHO_469X214_2': 1,
            'LARGUERO_2435_ANTEPECHO': 2,
            'PANEL_ANTEPECHO_2449X214': 1,
            'LARGUERO_2435_INTERMERDIO': 0,
        }
    },
    'ST': {
        nombre: 'Stands en Tren',
        componentes: {
            'POSTES_2500': 6,
            'POSTES_300_ANTEPECHO': 1,
            'LARGUERO_950': 10,
            'LARGUERO_1940_ANTEPECHO': 2,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 5,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO1': 4,
            'MAMPARA_ANTEPECHO_469X214_1': 2,
            'LARGUERO_ANTEPECHO_2930': 2,
            'LARGUERO_455': 2,
            'MAMPARA_469X2390': 1,
            'LARGUERO_455_ANTEPECHO2': 0, 
            'MAMPARA_ANTEPECHO_469X214_2': 0,
            'LARGUERO_2435_ANTEPECHO': 0,
            'PANEL_ANTEPECHO_2449X214': 0,
            'LARGUERO_2435_INTERMERDIO': 0,
        }
    },
    'VTL': {
        nombre: 'Vuelta Tren en L',
        componentes: {
            'POSTES_2500': 7,
            'POSTES_300_ANTEPECHO': 2,
            'LARGUERO_950': 10,
            'LARGUERO_1940_ANTEPECHO': 4,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 5,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 2,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO1': 4,
            'MAMPARA_ANTEPECHO_469X214_1': 2,
            'LARGUERO_ANTEPECHO_2930': 2,
            'LARGUERO_455': 2,
            'MAMPARA_469X2390': 1,
            'LARGUERO_455_ANTEPECHO2': 2, 
            'MAMPARA_ANTEPECHO_469X214_2': 1,
            'LARGUERO_2435_ANTEPECHO': 2,
            'PANEL_ANTEPECHO_2449X214': 1,
            'LARGUERO_2435_INTERMERDIO': 0,
        }
    },
    'VTU': {
        nombre: 'Vuelta Tren en U',
        componentes: {
            'POSTES_2500': 9,
            'POSTES_300_ANTEPECHO': 1,
            'LARGUERO_950': 14,
            'LARGUERO_1940_ANTEPECHO': 2,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 7,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO1': 4,
            'MAMPARA_ANTEPECHO_469X214_1': 2,
            'LARGUERO_ANTEPECHO_2930': 2,
            'LARGUERO_455': 4,
            'MAMPARA_469X2390': 2,
            'LARGUERO_455_ANTEPECHO2': 0, 
            'MAMPARA_ANTEPECHO_469X214_2': 0,
            'LARGUERO_2435_ANTEPECHO': 0,
            'PANEL_ANTEPECHO_2449X214': 0,
            'LARGUERO_2435_INTERMERDIO': 0,
        }
    },
    'VTI': {
        nombre: 'Vuelta de Tren Inversa',
        componentes: {
            'POSTES_2500': 5,
            'POSTES_300_ANTEPECHO': 2,
            'LARGUERO_950': 4,
            'LARGUERO_1940_ANTEPECHO': 4,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 2,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 2,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO1': 4,
            'MAMPARA_ANTEPECHO_469X214_1': 2,
            'LARGUERO_ANTEPECHO_2930': 2,
            'LARGUERO_455': 4,
            'MAMPARA_469X2390': 1,
            'LARGUERO_455_ANTEPECHO2': 2,
            'MAMPARA_ANTEPECHO_469X214_2': 1,
            'LARGUERO_2435_ANTEPECHO': 2,
            'PANEL_ANTEPECHO_2449X214': 1,
            'LARGUERO_2435_INTERMERDIO': 0,
        }
    },
    'FT': {
        nombre: 'Final de Tren',
        componentes: {
            'POSTES_2500': 4,
            'POSTES_300_ANTEPECHO': 2,
            'LARGUERO_950': 6,
            'LARGUERO_1940_ANTEPECHO': 4,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 3,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 2,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO1': 4,
            'MAMPARA_ANTEPECHO_469X214_1': 2,
            'LARGUERO_ANTEPECHO_2930': 2,
            'LARGUERO_455': 0,
            'MAMPARA_469X2390': 0,
            'LARGUERO_455_ANTEPECHO2': 2,
            'MAMPARA_ANTEPECHO_469X214_2': 1,
            'LARGUERO_2435_ANTEPECHO': 2,
            'PANEL_ANTEPECHO_2449X214': 1,
            'LARGUERO_2435_INTERMERDIO': 0,
        }
    },
    'EI': {
        nombre: 'Esquina de Isla',
        componentes: {
            'POSTES_2500': 4.25,
            'POSTES_300_ANTEPECHO': 2,
            'LARGUERO_950': 5,
            'LARGUERO_1940_ANTEPECHO': 4,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 2.5,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 2,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO1': 4,
            'MAMPARA_ANTEPECHO_469X214_1': 2,
            'LARGUERO_ANTEPECHO_2930': 2,
            'LARGUERO_455': 1,
            'MAMPARA_469X2390': 0.5,
            'LARGUERO_455_ANTEPECHO2': 2,
            'MAMPARA_ANTEPECHO_469X214_2': 1,
            'LARGUERO_2435_ANTEPECHO': 2,
            'PANEL_ANTEPECHO_2449X214': 1,
            'LARGUERO_2435_INTERMERDIO': 0,
        }
    },
    'II': {
        nombre: 'Intermedio de Isla',
        componentes: {
            'POSTES_2500': 4.5,
            'POSTES_300_ANTEPECHO': 1,
            'LARGUERO_950': 7,
            'LARGUERO_1940_ANTEPECHO': 2,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 3.5,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO1': 4,
            'MAMPARA_ANTEPECHO_469X214_1': 2,
            'LARGUERO_ANTEPECHO_2930': 2,
            'LARGUERO_455': 2,
            'MAMPARA_469X2390': 1,
            'LARGUERO_455_ANTEPECHO2': 0,
            'MAMPARA_ANTEPECHO_469X214_2': 0,
            'LARGUERO_2435_ANTEPECHO': 0,
            'PANEL_ANTEPECHO_2449X214': 0,
            'LARGUERO_2435_INTERMERDIO': 0,
        }
    },
    'IT': {
        nombre: 'Intermedio de Tren',
        componentes: {
            'POSTES_2500': 4,
            'POSTES_300_ANTEPECHO': 1,
            'LARGUERO_950': 6,
            'LARGUERO_1940_ANTEPECHO': 2,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 3,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO1': 4,
            'MAMPARA_ANTEPECHO_469X214_1': 2,
            'LARGUERO_ANTEPECHO_2930': 2,
            'LARGUERO_455': 0,
            'MAMPARA_469X2390': 0,
            'LARGUERO_455_ANTEPECHO2': 0, 
            'MAMPARA_ANTEPECHO_469X214_2': 0,
            'LARGUERO_2435_ANTEPECHO': 1,
            'PANEL_ANTEPECHO_2449X214': 0,
            'LARGUERO_2435_INTERMERDIO': 1,
        }
    },
    'VIT': {
        nombre: 'Vuelta Intermedio de Tren',
        componentes: {
            'POSTES_2500': 7,
            'POSTES_300_ANTEPECHO': 1,
            'LARGUERO_950': 10,
            'LARGUERO_1940_ANTEPECHO': 2,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 5,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO1': 4,
            'MAMPARA_ANTEPECHO_469X214_1': 2,
            'LARGUERO_ANTEPECHO_2930': 2,
            'LARGUERO_455': 2,
            'MAMPARA_469X2390': 1,
            'LARGUERO_455_ANTEPECHO2': 0,
            'MAMPARA_ANTEPECHO_469X214_2': 0,
            'LARGUERO_2435_ANTEPECHO': 0,
            'PANEL_ANTEPECHO_2449X214': 0,
            'LARGUERO_2435_INTERMERDIO': 1,
        }
    },
    'CTIU': {
        nombre: 'Cabecera de Tren Intermedia en U',
        componentes: {
            'POSTES_2500': 8,
            'POSTES_300_ANTEPECHO': 1,
            'LARGUERO_950': 10,
            'LARGUERO_1940_ANTEPECHO': 2,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 5,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO1': 4,
            'MAMPARA_ANTEPECHO_469X214_1': 2,
            'LARGUERO_ANTEPECHO_2930': 2,
            'LARGUERO_455': 2,
            'MAMPARA_469X2390': 1,
            'LARGUERO_455_ANTEPECHO2': 0,
            'MAMPARA_ANTEPECHO_469X214_2': 0,
            'LARGUERO_2435_ANTEPECHO': 0,
            'PANEL_ANTEPECHO_2449X214': 0,
            'LARGUERO_2435_INTERMERDIO': 1,
        }
    },
    'CTIL': {
        nombre: 'Cabecera de Tren Intermedia en L',
        componentes: {
            'POSTES_2500': 6,
            'POSTES_300_ANTEPECHO': 2,
            'LARGUERO_950': 6,
            'LARGUERO_1940_ANTEPECHO': 4,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 3,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 2,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO1': 4,
            'MAMPARA_ANTEPECHO_469X214_1': 2,
            'LARGUERO_ANTEPECHO_2930': 2,
            'LARGUERO_455': 0,
            'MAMPARA_469X2390': 0,
            'LARGUERO_455_ANTEPECHO2': 2,
            'MAMPARA_ANTEPECHO_469X214_2': 1,
            'LARGUERO_2435_ANTEPECHO': 2,
            'PANEL_ANTEPECHO_2449X214': 1,
            'LARGUERO_2435_INTERMERDIO': 1,
        }
    }
};

function mostrarResultados3x2_5x2_5(contenedor, resultado, tipoStand, tipoResultado) {
    const componentes = resultado.componentes;
    
    function getCantidad(codigo) {
        const comp = componentes.find(c => c.codigo === codigo);
        return comp ? comp.cantidadTotal : 0;
    }

    const standsConMultiplicador1_5 = ['SE', 'VTL', 'VTI', 'FT', 'EI', 'CTIL'];
    const multiplicadorPostes300 = standsConMultiplicador1_5.includes(tipoStand) ? 1.5 : 2;
    
    // Array para guardar los materiales que se mostrarán
    let materialesFiltrados = [];
    
    // Mostrar solo el tipo seleccionado
    if (tipoResultado === 'TIPO1') {
        materialesFiltrados = [
            { codigo: 'POSTES_2500', nombre: 'TOTAL POSTES 2500', cantidad: getCantidad('POSTES_2500') },
            { codigo: 'POSTES_300_ANTEPECHO', nombre: 'TOTAL POSTES 300', cantidad: getCantidad('POSTES_300_ANTEPECHO') },
            { codigo: 'LARGUERO_950', nombre: 'TOTAL LARGUERO 950', cantidad: getCantidad('LARGUERO_950') + getCantidad('LARGUERO_950_ANTEPECHO') },
            { codigo: 'LARGUERO_1940_ANTEPECHO', nombre: 'TOTAL LARGUERO ANTEPECHO 1940', cantidad: getCantidad('LARGUERO_1940_ANTEPECHO') },
            { codigo: 'MAMPARA_964X2390', nombre: 'TOTAL MAMPARA 964 X 2390', cantidad: getCantidad('MAMPARA_964X2390') },
            { codigo: 'MAMPARA_ANTEPECHO_CURVO_2400X300', nombre: 'TOTAL PANEL ANTEPECHO CURVO 2400 X 300', cantidad: getCantidad('MAMPARA_ANTEPECHO_CURVO_2400X300') },
            { codigo: 'MAMPARA_ANTEPECHO_964X214', nombre: 'TOTAL PANEL ANTEPECHO 964 X 214', cantidad: getCantidad('MAMPARA_ANTEPECHO_964X214') },
            { codigo: 'LARGUERO_455', nombre: 'TOTAL LARGUERO 455', cantidad: getCantidad('LARGUERO_455') + getCantidad('LARGUERO_455_ANTEPECHO2') },
            { codigo: 'MAMPARA_469X2390', nombre: 'TOTAL MAMPARA 469 X 2390', cantidad: getCantidad('MAMPARA_469X2390') },
            { codigo: 'MAMPARA_ANTEPECHO_469X214_2', nombre: 'TOTAL PANEL ANTEPECHO O 469 X 214 LATERAL', cantidad: getCantidad('MAMPARA_ANTEPECHO_469X214_2') },
            { codigo: 'LARGUERO_2435', nombre: 'TOTAL LARGUERO 2435', cantidad: getCantidad('LARGUERO_2435') }
        ];
        agregarSeccion(contenedor, 'TOTALES STAND TIPO 1 (ANTEPECHO CURVO LATERAL)', materialesFiltrados.map(m => ({ nombre: m.nombre, cantidad: m.cantidad })));
        
    } else if (tipoResultado === 'TIPO2') {
        materialesFiltrados = [
            { codigo: 'POSTES_2500', nombre: 'TOTAL POSTES 2500', cantidad: getCantidad('POSTES_2500') },
            { codigo: 'POSTES_300_ANTEPECHO', nombre: 'TOTAL POSTES 300', cantidad: getCantidad('POSTES_300_ANTEPECHO') * multiplicadorPostes300 },
            { codigo: 'LARGUERO_950', nombre: 'TOTAL LARGUERO 950', cantidad: getCantidad('LARGUERO_950') },
            { codigo: 'LARGUERO_455', nombre: 'TOTAL LARGUERO 455', cantidad: getCantidad('LARGUERO_455') + getCantidad('LARGUERO_455_ANTEPECHO1') + getCantidad('LARGUERO_455_ANTEPECHO2') },
            { codigo: 'LARGUERO_1940_ANTEPECHO', nombre: 'TOTAL LARGUERO ANTEPECHO 1940', cantidad: getCantidad('LARGUERO_1940_ANTEPECHO') },
            { codigo: 'MAMPARA_964X2390', nombre: 'TOTAL MAMPARA 964 X 2390', cantidad: getCantidad('MAMPARA_964X2390') },
            { codigo: 'MAMPARA_ANTEPECHO_CURVO_2400X300', nombre: 'TOTAL PANEL ANTEPECHO CURVO 2200 X 300', cantidad: getCantidad('MAMPARA_ANTEPECHO_CURVO_2400X300') },
            { codigo: 'MAMPARA_ANTEPECHO_469X214', nombre: 'TOTAL PANEL ANTEPECHO 469 X 214', cantidad: getCantidad('MAMPARA_ANTEPECHO_469X214_1') + getCantidad('MAMPARA_ANTEPECHO_469X214_2') },
            { codigo: 'MAMPARA_469X2390', nombre: 'TOTAL MAMPARA 469 X 2390', cantidad: getCantidad('MAMPARA_469X2390') },
            { codigo: 'LARGUERO_2435_INTERMERDIO', nombre: 'TOTAL LARGUERO 2435', cantidad: getCantidad('LARGUERO_2435_INTERMERDIO') }
        ];
        agregarSeccion(contenedor, 'TOTALES STAND TIPO 2 (ANTEPECHO CURVO AL CENTRO)', materialesFiltrados.map(m => ({ nombre: m.nombre, cantidad: m.cantidad })));
        
    } else if (tipoResultado === 'TIPO3') {
        materialesFiltrados = [
            { codigo: 'POSTES_2500', nombre: 'TOTAL POSTES 2500', cantidad: getCantidad('POSTES_2500') },
            { codigo: 'LARGUERO_950', nombre: 'TOTAL LARGUERO 950', cantidad: getCantidad('LARGUERO_950') },
            { codigo: 'LARGUERO_2435', nombre: 'TOTAL LARGUERO 2435', cantidad: getCantidad('LARGUERO_2435_ANTEPECHO') + getCantidad('LARGUERO_2435_INTERMERDIO') },
            { codigo: 'LARGUERO_ANTEPECHO_2930', nombre: 'TOTAL LARGUERO ANTEPECHO 2930', cantidad: getCantidad('LARGUERO_ANTEPECHO_2930') },
            { codigo: 'MAMPARA_964X2390', nombre: 'TOTAL MAMPARA 964 X 2390', cantidad: getCantidad('MAMPARA_964X2390') },
            { codigo: 'PANEL_ANTEPECHO_2449X214', nombre: 'TOTAL PANEL ANTEPECHO 2449 X 214', cantidad: getCantidad('PANEL_ANTEPECHO_2449X214') },
            { codigo: 'LARGUERO_455', nombre: 'TOTAL LARGUERO 455', cantidad: getCantidad('LARGUERO_455') },
            { codigo: 'MAMPARA_469X2390', nombre: 'TOTAL MAMPARA 469 X 2390', cantidad: getCantidad('MAMPARA_469X2390') },
            { codigo: 'MAMPARA_ANTEPECHO_CURVO_2400X300', nombre: 'TOTAL PANEL ANTEPECHO 2944 X 214', cantidad: getCantidad('MAMPARA_ANTEPECHO_CURVO_2400X300') }
        ];
        agregarSeccion(contenedor, 'TOTALES STAND TIPO 3 (ANTEPECHO RECTO)', materialesFiltrados.map(m => ({ nombre: m.nombre, cantidad: m.cantidad })));
        
    } else if (tipoResultado === 'TIPO4') {
        materialesFiltrados = [
            { codigo: 'POSTES_2500', nombre: 'TOTAL POSTES 2500', cantidad: getCantidad('POSTES_2500') },
            { codigo: 'LARGUERO_950', nombre: 'TOTAL LARGUERO 950', cantidad: getCantidad('LARGUERO_950') },
            { codigo: 'MAMPARA_964X2390', nombre: 'TOTAL MAMPARA 964 X 2390', cantidad: getCantidad('MAMPARA_964X2390') },
            { codigo: 'PANEL_ANTEPECHO_2449X214', nombre: 'TOTAL PANEL ART ANTEPECHO O CON GANCHOS 2435 X 300', cantidad: getCantidad('PANEL_ANTEPECHO_2449X214') },
            { codigo: 'LARGUERO_455', nombre: 'TOTAL LARGUERO 455', cantidad: getCantidad('LARGUERO_455') },
            { codigo: 'MAMPARA_469X2390', nombre: 'TOTAL MAMPARA 469 X 2390', cantidad: getCantidad('MAMPARA_469X2390') },
            { codigo: 'MAMPARA_ANTEPECHO_CURVO_2400X300', nombre: 'TOTAL PANEL ART ANTEPECHO O CON GANCHOS 2930 X 300', cantidad: getCantidad('MAMPARA_ANTEPECHO_CURVO_2400X300') },
            { codigo: 'LARGUERO_2435', nombre: 'TOTAL LARGUERO 2435', cantidad: getCantidad('LARGUERO_2435') }
        ];
        agregarSeccion(contenedor, 'TOTALES STAND TIPO 4 (ANTEPECHO RECTO DE PAEL ART CON GANCHOS)', materialesFiltrados.map(m => ({ nombre: m.nombre, cantidad: m.cantidad })));
    }
    
    // RETORNAR los materiales filtrados
    return materialesFiltrados;
}

function agregarSeccion(contenedor, titulo, items) {
    const seccion = document.createElement('div');
    seccion.className = 'seccion-stand';
    
    const h4 = document.createElement('h4');
    h4.textContent = titulo;
    h4.className = 'titulo-seccion';
    seccion.appendChild(h4);
    
    const table = document.createElement('table');
    table.className = 'table table-striped table-bordered';
    
    const thead = document.createElement('thead');
    thead.innerHTML = `
        <tr>
            <th>Componente</th>
            <th>Cantidad</th>
        </tr>
    `;
    table.appendChild(thead);
    
    const tbody = document.createElement('tbody');
    items.forEach(item => {
        const tr = document.createElement('tr');
        tr.innerHTML = `
            <td>${item.nombre}</td>
            <td class="text-end">${item.cantidad}</td>
        `;
        tbody.appendChild(tr);
    });
    table.appendChild(tbody);
    
    seccion.appendChild(table);
    contenedor.appendChild(seccion);
}
