// Despiece para medida 3.00 x 2.00 x 2.50 M

const despiece_3x2x2_5 = {
    // Cabecera de Tren en U
    'SC': {
        nombre: 'Stand en Cajon',
        componentes: {
            'POSTES_2500': 8,
            'LARGUERO_950': 14,
            'LARGUERO_1940_ANTEPECHO': 0,
            'MAMPARA_1940_ANTEPECHO':0,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 7,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGERO_455_ANTEPECHO': 4,
            'MAMPARA_ANTEPECHO_469X214': 2,
            'LARGUERO_ANTEPECHO_2930': 2,
            'MAMPARA_ANTEPECHO_2944': 1
        }
    },
    // Cabecera de Tren en L
    'SE': {
        nombre: 'Stand en Esquina',
        componentes: {
            'POSTES_2500': 7,
            'LARGUERO_950': 10,
            'LARGUERO_1940_ANTEPECHO': 2,
            'MAMPARA_1940_ANTEPECHO':1,
            'LARGUERO_950_ANTEPECHO': 4,
            'MAMPARA_964X2390': 5,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 2,
            'MAMPARA_ANTEPECHO_964X214': 2,
            'LARGERO_455_ANTEPECHO': 8,
            'MAMPARA_ANTEPECHO_469X214': 4,
            'LARGUERO_ANTEPECHO_2930': 2,
            'MAMPARA_ANTEPECHO_2944': 1
        }
    },
    // Stands en Tren
    'ST': {
        nombre: 'Stands en Tren',
        componentes: {
            'POSTES_2500': 5,
            'LARGUERO_950': 10,
            'LARGUERO_1940_ANTEPECHO': 0,
            'MAMPARA_1940_ANTEPECHO':0,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 5,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGERO_455_ANTEPECHO': 4,
            'MAMPARA_ANTEPECHO_469X214': 2,
            'LARGUERO_ANTEPECHO_2930': 2,
            'MAMPARA_ANTEPECHO_2944': 1
        }
    },
    // Vuelta Tren en L
    'VTL': {
        nombre: 'Vuelta Tren en L',
        componentes: {
            'POSTES_2500': 6,
            'LARGUERO_950': 10,
            'LARGUERO_1940_ANTEPECHO': 2,
            'MAMPARA_1940_ANTEPECHO':1,
            'LARGUERO_950_ANTEPECHO': 4,
            'MAMPARA_964X2390': 5,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 2,
            'MAMPARA_ANTEPECHO_964X214': 2,
            'LARGERO_455_ANTEPECHO': 8,
            'MAMPARA_ANTEPECHO_469X214': 4,
            'LARGUERO_ANTEPECHO_2930': 2,
            'MAMPARA_ANTEPECHO_2944': 1
        }
    },
    // Vuelta Tren en U
    'VTU': {
        nombre: 'Vuelta Tren en U',
        componentes: {
            'POSTES_2500': 7,
            'LARGUERO_950': 14,
            'LARGUERO_1940_ANTEPECHO': 0,
            'MAMPARA_1940_ANTEPECHO': 0,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 7,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGERO_455_ANTEPECHO': 4,
            'MAMPARA_ANTEPECHO_469X214': 2,
            'LARGUERO_ANTEPECHO_2930': 2,
            'MAMPARA_ANTEPECHO_2944': 1
        }
    },
    // Tren en Vuelta
    'VTI': {
        nombre: 'Tren en Vuelta',
        componentes: {
            'POSTES_2500': 4,
            'LARGUERO_950': 6,
            'LARGUERO_1940_ANTEPECHO': 2,
            'MAMPARA_1940_ANTEPECHO':1,
            'LARGUERO_950_ANTEPECHO': 4,
            'MAMPARA_964X2390': 3,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 2,
            'MAMPARA_ANTEPECHO_964X214': 2,
            'LARGERO_455_ANTEPECHO': 8,
            'MAMPARA_ANTEPECHO_469X214': 4,
            'LARGUERO_ANTEPECHO_2930': 2,
            'MAMPARA_ANTEPECHO_2944': 1
        }
    },
    // Final de Tren
    'FT': {
        nombre: 'Final de Tren',
        componentes: {
            'POSTES_2500': 4,
            'LARGUERO_950': 6,
            'LARGUERO_1940_ANTEPECHO': 2,
            'MAMPARA_1940_ANTEPECHO': 1,
            'LARGUERO_950_ANTEPECHO': 4,
            'MAMPARA_964X2390': 3,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 2,
            'MAMPARA_ANTEPECHO_964X214': 2,
            'LARGERO_455_ANTEPECHO': 8,
            'MAMPARA_ANTEPECHO_469X214': 4,
            'LARGUERO_ANTEPECHO_2930': 2,
            'MAMPARA_ANTEPECHO_2944': 1
        }
    },
    // Esquina de Isla
    'EI': {
        nombre: 'Esquina de Isla',
        componentes: {
            'POSTES_2500': 3.75,
            'LARGUERO_950': 5,
            'LARGUERO_1940_ANTEPECHO': 2,
            'MAMPARA_1940_ANTEPECHO': 1,
            'LARGUERO_950_ANTEPECHO': 4,
            'MAMPARA_964X2390': 2.5,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 2,
            'MAMPARA_ANTEPECHO_964X214': 2,
            'LARGERO_455_ANTEPECHO': 8,
            'MAMPARA_ANTEPECHO_469X214': 4,
            'LARGUERO_ANTEPECHO_2930': 2,
            'MAMPARA_ANTEPECHO_2944': 1
        }
    },
    // Intermedio de Isla
    'II': {
        nombre: 'Intermedio de Isla',
        componentes: {
            'POSTES_2500': 3.5,
            'LARGUERO_950': 7,
            'LARGUERO_1940_ANTEPECHO': 0,
            'MAMPARA_1940_ANTEPECHO': 0,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 3.5,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGERO_455_ANTEPECHO': 4,
            'MAMPARA_ANTEPECHO_469X214': 2,
            'LARGUERO_ANTEPECHO_2930': 2,
            'MAMPARA_ANTEPECHO_2944': 1
        }
    },
    // Intermedio de Tren
    'IT': {
        nombre: 'Intermedio de Tren',
        componentes: {
            'POSTES_2500': 4,
            'LARGUERO_950': 6,
            'LARGUERO_1940_ANTEPECHO': 1,
            'MAMPARA_1940_ANTEPECHO':0,
            'MAMPARA_964X2390': 3,
            'LARGUERO_ANTEPECHO_2930': 2,
            'MAMPARA_ANTEPECHO_2944': 1
        }
    },
    // Vuelta Intermedio de Tren
    'VIT': {
        nombre: 'Vuelta Intermedio de Tren',
        componentes: {
            'POSTES_2500': 6,
            'LARGUERO_950': 10,
            'LARGUERO_1940_ANTEPECHO': 1,
            'MAMPARA_1940_ANTEPECHO':0,
            'MAMPARA_964X2390': 5,
            'LARGUERO_ANTEPECHO_2930': 2,
            'MAMPARA_ANTEPECHO_2944': 1
        }
    },
    // Cabecera de Tren Intermedia en U
    'CTIU': {
        nombre: 'Cabecera de Tren Intermedia en U',
        componentes: {
            'POSTES_2500': 7,
            'LARGUERO_950': 10,
            'LARGUERO_1940_ANTEPECHO': 1,
            'MAMPARA_1940_ANTEPECHO':0,
            'MAMPARA_964X2390': 5,
            'LARGUERO_ANTEPECHO_2930': 2,
            'MAMPARA_ANTEPECHO_2944': 1
        }
    },
    // Cabecera de Tren Intermedia en L
    'CTIL': {
        nombre: 'Cabecera de Tren Intermedia en L',
        componentes: {
            'POSTES_2500': 6,
            'LARGUERO_950': 6,
            'LARGUERO_1940_ANTEPECHO': 3,
            'MAMPARA_1940_ANTEPECHO': 1,
            'MAMPARA_964X2390': 3,
            'LARGUERO_ANTEPECHO_2930': 2,
            'MAMPARA_ANTEPECHO_2944': 1
        }
    },
    
};

// Funcion para mostrar los resultados en el modal de medida 3x2x2.5
function mostrarResultados3x2x2_5(contenedor, resultado, tipoResultado) {
    // Obtener la referencia a los componentes del resultado
    const componentes = resultado.componentes;
    
    // Funcion auxiliar para obtener la cantidad de un componente
    function getCantidad(codigo) {
        const comp = componentes.find(c => c.codigo === codigo);
        return comp ? comp.cantidadTotal : 0;
    }
    
    // Array para guardar los materiales que se mostrarán
    let materialesFiltrados = [];
    
    // Mostrar solo el tipo seleccionado
    if (tipoResultado === 'TIPO3') {
        materialesFiltrados = [
            { codigo: 'POSTES_2500', nombre: 'TOTAL POSTES 2500mm', cantidad: getCantidad('POSTES_2500') },
            { codigo: 'LARGUERO_950', nombre: 'TOTAL LARGUERO 950mm', cantidad: getCantidad('LARGUERO_950') },
            { codigo: 'LARGUERO_ANTEPECHO_2930', nombre: 'TOTAL LARGUERO ANTEPECHO 2930mm', cantidad: getCantidad('LARGUERO_ANTEPECHO_2930') },
            { codigo: 'MAMPARA_964X2390', nombre: 'TOTAL MAMPARA 964x2390mm', cantidad: getCantidad('MAMPARA_964X2390') },
            { codigo: 'MAMPARA_ANTEPECHO_2944', nombre: 'TOTAL PANEL ANTEPECHO 2944x214mm', cantidad: getCantidad('MAMPARA_ANTEPECHO_2944') },
            { codigo: 'LARGUERO_1940_ANTEPECHO', nombre: 'TOTAL LARGUERO ANTEPECHO 1940mm', cantidad: getCantidad('LARGUERO_1940_ANTEPECHO') },
            { codigo: 'MAMPARA_1940_ANTEPECHO', nombre: 'TOTAL PANEL ANTEPECHO 1954x214mm', cantidad: getCantidad('MAMPARA_1940_ANTEPECHO') }
        ];
        agregarSeccion(contenedor, 'Totales Stands tipo 3 (Antepecho Recto)', materialesFiltrados.map(m => ({ nombre: m.nombre, cantidad: m.cantidad })));
        
    } else if (tipoResultado === 'TIPO4') {
        materialesFiltrados = [
            { codigo: 'POSTES_2500', nombre: 'TOTAL POSTES 2500mm', cantidad: getCantidad('POSTES_2500') },
            { codigo: 'LARGUERO_950', nombre: 'TOTAL LARGUERO 950mm', cantidad: getCantidad('LARGUERO_950') },
            { codigo: 'MAMPARA_964X2390', nombre: 'TOTAL MAMPARA 964x2390mm', cantidad: getCantidad('MAMPARA_964X2390') },
            { codigo: 'MAMPARA_ANTEPECHO_2944', nombre: 'TOTAL PANEL ART ANTEPECHO CON GANCHOS 2930x300mm', cantidad: getCantidad('MAMPARA_ANTEPECHO_2944') },
            { codigo: 'MAMPARA_1940_ANTEPECHO', nombre: 'TOTAL PANEL ART ANTEPECHO CON GANCHOS 1940x300mm', cantidad: getCantidad('MAMPARA_1940_ANTEPECHO') }
        ];
        agregarSeccion(contenedor, 'Totales Stand tipo 4 (Antepecho Recto de Panel Art con Ganchos)', materialesFiltrados.map(m => ({ nombre: m.nombre, cantidad: m.cantidad })));
    }
    
    // RETORNAR los materiales filtrados
    return materialesFiltrados;
}
