// Despiece para medida 3.00 x 3.00 x 2.50 M

const despiece_3x3x2_5 = {
    'SC': {
        nombre: 'Stand en Cajon',
        componentes: {
            'POSTES_2500': 10,
            'POSTES_300_ANTEPECHO': 1,
            'LARGUERO_950': 18,
            'LARGUERO_1940_ANTEPECHO': 2,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 9,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO': 4,
            'MAMPARA_ANTEPECHO_469X214': 2,
            'LARGUERO_ANTEPECHO_2930': 2
        }
    },
    'SE': {
        nombre: 'Stand en Esquina',
        componentes: {
            'POSTES_2500': 8,
            'POSTES_300_ANTEPECHO': 2,
            'LARGUERO_950': 12,
            'LARGUERO_1940_ANTEPECHO': 4,
            'LARGUERO_950_ANTEPECHO': 4,
            'MAMPARA_964X2390': 6,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 2,
            'MAMPARA_ANTEPECHO_964X214': 2,
            'LARGUERO_455_ANTEPECHO': 8,
            'MAMPARA_ANTEPECHO_469X214': 4,
            'LARGUERO_ANTEPECHO_2930': 4
        }
    },
    'ST': {
        nombre: 'Stands en Tren',
        componentes: {
            'POSTES_2500': 6,
            'POSTES_300_ANTEPECHO': 1,
            'LARGUERO_950': 12,
            'LARGUERO_1940_ANTEPECHO': 2,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 6,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO': 4,
            'MAMPARA_ANTEPECHO_469X214': 2,
            'LARGUERO_ANTEPECHO_2930': 2
        }
    },
    'VTL': {
        nombre: 'Vuelta Tren en L',
        componentes: {
            'POSTES_2500': 7,
            'POSTES_300_ANTEPECHO': 2,
            'LARGUERO_950': 12,
            'LARGUERO_1940_ANTEPECHO': 4,
            'LARGUERO_950_ANTEPECHO': 4,
            'MAMPARA_964X2390': 6,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 2,
            'MAMPARA_ANTEPECHO_964X214': 2,
            'LARGUERO_455_ANTEPECHO': 8,
            'MAMPARA_ANTEPECHO_469X214': 4,
            'LARGUERO_ANTEPECHO_2930': 4
        }
    },
    'VTU': {
        nombre: 'Vuelta Tren en U',
        componentes: {
            'POSTES_2500': 9,
            'POSTES_300_ANTEPECHO': 1,
            'LARGUERO_950': 18,
            'LARGUERO_1940_ANTEPECHO': 2,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 9,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO': 4,
            'MAMPARA_ANTEPECHO_469X214': 2,
            'LARGUERO_ANTEPECHO_2930': 2
        }
    },
    'VTI': {
        nombre: 'Tren en Vuelta',
        componentes: {
            'POSTES_2500': 4,
            'POSTES_300_ANTEPECHO': 2,
            'LARGUERO_950': 6,
            'LARGUERO_1940_ANTEPECHO': 4,
            'LARGUERO_950_ANTEPECHO': 4,
            'MAMPARA_964X2390': 3,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 2,
            'MAMPARA_ANTEPECHO_964X214': 2,
            'LARGUERO_455_ANTEPECHO': 8,
            'MAMPARA_ANTEPECHO_469X214': 4,
            'LARGUERO_ANTEPECHO_2930': 4
        }
    },
    'FT': {
        nombre: 'Final de Tren',
        componentes: {
            'POSTES_2500': 4,
            'POSTES_300_ANTEPECHO': 2,
            'LARGUERO_950': 6,
            'LARGUERO_1940_ANTEPECHO': 4,
            'LARGUERO_950_ANTEPECHO': 4,
            'MAMPARA_964X2390': 3,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 2,
            'MAMPARA_ANTEPECHO_964X214': 2,
            'LARGUERO_455_ANTEPECHO': 8,
            'MAMPARA_ANTEPECHO_469X214': 4,
            'LARGUERO_ANTEPECHO_2930': 4
        }
    },
    'EI': {
        nombre: 'Esquina de Isla',
        componentes: {
            'POSTES_2500': 4.25,
            'POSTES_300_ANTEPECHO': 2,
            'LARGUERO_950': 6,
            'LARGUERO_1940_ANTEPECHO': 4,
            'LARGUERO_950_ANTEPECHO': 4,
            'MAMPARA_964X2390': 3,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 2,
            'MAMPARA_ANTEPECHO_964X214': 2,
            'LARGUERO_455_ANTEPECHO': 8,
            'MAMPARA_ANTEPECHO_469X214': 4,
            'LARGUERO_ANTEPECHO_2930': 4
        }
    },
    'II': {
        nombre: 'Intermedio de Isla',
        componentes: {
            'POSTES_2500': 4.5,
            'POSTES_300_ANTEPECHO': 1,
            'LARGUERO_950': 9,
            'LARGUERO_1940_ANTEPECHO': 2,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 4.5,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO': 4,
            'MAMPARA_ANTEPECHO_469X214': 2,
            'LARGUERO_ANTEPECHO_2930': 2
        }
    },
    'IT': {
        nombre: 'Intermedio de Tren',
        componentes: {
            'POSTES_2500': 4,
            'POSTES_300_ANTEPECHO': 1,
            'LARGUERO_950': 6,
            'LARGUERO_1940_ANTEPECHO': 2,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 3,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO': 4,
            'MAMPARA_ANTEPECHO_469X214': 2,
            'LARGUERO_ANTEPECHO_2930': 3
        }
    },
    'VIT': {
        nombre: 'Vuelta Intermedio de Tren',
        componentes: {
            'POSTES_2500': 7,
            'POSTES_300_ANTEPECHO': 2,
            'LARGUERO_950': 12,
            'LARGUERO_1940_ANTEPECHO': 2,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 6,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO': 4,
            'MAMPARA_ANTEPECHO_469X214': 2,
            'LARGUERO_ANTEPECHO_2930': 3
        }
    },
    'CTIU': {
        nombre: 'Cabecera de Tren Intermedia en U',
        componentes: {
            'POSTES_2500': 8,
            'POSTES_300_ANTEPECHO': 1,
            'LARGUERO_950': 12,
            'LARGUERO_1940_ANTEPECHO': 2,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 6,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO': 4,
            'MAMPARA_ANTEPECHO_469X214': 2,
            'LARGUERO_ANTEPECHO_2930': 3
        }
    },
    'CTIL': {
        nombre: 'Cabecera de Tren Intermedia en L',
        componentes: {
            'POSTES_2500': 6,
            'POSTES_300_ANTEPECHO': 2,
            'LARGUERO_950': 6,
            'LARGUERO_1940_ANTEPECHO': 4,
            'LARGUERO_950_ANTEPECHO': 4,
            'MAMPARA_964X2390': 3,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 2,
            'MAMPARA_ANTEPECHO_964X214': 2,
            'LARGUERO_455_ANTEPECHO': 8,
            'MAMPARA_ANTEPECHO_469X214': 4,
            'LARGUERO_ANTEPECHO_2930': 5
        }
    },
    'REGISTROS': {
        nombre: 'Stand de Registros',
        componentes: {
            'POSTES_2500': 6,
            'POSTES_300_ANTEPECHO': 1,
            'LARGUERO_950': 12,
            'LARGUERO_1940_ANTEPECHO': 2,
            'LARGUERO_950_ANTEPECHO': 2,
            'MAMPARA_964X2390': 6,
            'MAMPARA_ANTEPECHO_CURVO_2400X300': 1,
            'MAMPARA_ANTEPECHO_964X214': 1,
            'LARGUERO_455_ANTEPECHO': 4,
            'MAMPARA_ANTEPECHO_469X214': 2,
            'LARGUERO_ANTEPECHO_2930': 2
        }
    }
};

// Funcion especifica para mostrar resultados de 3x3x2.5 con 8 secciones
function mostrarResultados3x3x2_5(contenedor, resultado, tipoResultado) {
    const componentes = resultado.componentes;
    
    // Funcion auxiliar para obtener cantidad
    function getCantidad(codigo) {
        const comp = componentes.find(c => c.codigo === codigo);
        return comp ? comp.cantidadTotal : 0;
    }
    
    // Array para guardar los materiales que se mostrarán
    let materialesFiltrados = [];
    
    // Mostrar solo el tipo seleccionado
    if (tipoResultado === 'TIPO1') {
        materialesFiltrados = [
            { codigo: 'POSTES_2500', nombre: 'TOTAL POSTES 2500', cantidad: getCantidad('POSTES_2500') },
            { codigo: 'POSTES_300_ANTEPECHO', nombre: 'TOTAL POSTES 300', cantidad: getCantidad('POSTES_300_ANTEPECHO') },
            { codigo: 'LARGUERO_950', nombre: 'TOTAL LARGUERO 950', cantidad: getCantidad('LARGUERO_950') },
            { codigo: 'LARGUERO_950_ANTEPECHO', nombre: 'TOTAL LARGUERO ANTEPECHO 950', cantidad: getCantidad('LARGUERO_950_ANTEPECHO') },
            { codigo: 'LARGUERO_1940_ANTEPECHO', nombre: 'TOTAL LARGUERO ANTEPECHO 1940', cantidad: getCantidad('LARGUERO_1940_ANTEPECHO') },
            { codigo: 'MAMPARA_964X2390', nombre: 'TOTAL MAMPARA 964 X 2390', cantidad: getCantidad('MAMPARA_964X2390') },
            { codigo: 'MAMPARA_ANTEPECHO_CURVO_2400X300', nombre: 'TOTAL PANEL ANTEPECHO CURVO 2200 X 300', cantidad: getCantidad('MAMPARA_ANTEPECHO_CURVO_2400X300') },
            { codigo: 'MAMPARA_ANTEPECHO_964X214', nombre: 'TOTAL PANEL ANTEPECHO 964 X 214', cantidad: getCantidad('MAMPARA_ANTEPECHO_964X214') }
        ];
        agregarSeccion(contenedor, 'TOTALES STAND TIPO 1 (ANTEPECHO CURVO LATERAL)', materialesFiltrados.map(m => ({ nombre: m.nombre, cantidad: m.cantidad })));
        
    } else if (tipoResultado === 'TIPO2') {
        materialesFiltrados = [
            { codigo: 'POSTES_2500', nombre: 'TOTAL POSTES 2500', cantidad: getCantidad('POSTES_2500') },
            { codigo: 'POSTES_300_ANTEPECHO', nombre: 'TOTAL POSTES 300', cantidad: getCantidad('POSTES_300_ANTEPECHO') * 2 },
            { codigo: 'LARGUERO_950', nombre: 'TOTAL LARGUERO 950', cantidad: getCantidad('LARGUERO_950') },
            { codigo: 'LARGUERO_455_ANTEPECHO', nombre: 'TOTAL LARGUERO ANTEPECHO 455', cantidad: getCantidad('LARGUERO_455_ANTEPECHO') },
            { codigo: 'LARGUERO_1940_ANTEPECHO', nombre: 'TOTAL LARGUERO ANTEPECHO 1940', cantidad: getCantidad('LARGUERO_1940_ANTEPECHO') },
            { codigo: 'MAMPARA_964X2390', nombre: 'TOTAL MAMPARA 964 X 2390', cantidad: getCantidad('MAMPARA_964X2390') },
            { codigo: 'MAMPARA_ANTEPECHO_CURVO_2400X300', nombre: 'TOTAL PANEL ANTEPECHO CURVO 2200 X 300', cantidad: getCantidad('MAMPARA_ANTEPECHO_CURVO_2400X300') },
            { codigo: 'MAMPARA_ANTEPECHO_469X214', nombre: 'TOTAL PANEL ANTEPECHO 469 X 214', cantidad: getCantidad('MAMPARA_ANTEPECHO_469X214') }
        ];
        agregarSeccion(contenedor, 'TOTALES STAND TIPO 2 (ANTEPECHO CURVO AL CENTRO)', materialesFiltrados.map(m => ({ nombre: m.nombre, cantidad: m.cantidad })));
        
    } else if (tipoResultado === 'TIPO3') {
        materialesFiltrados = [
            { codigo: 'POSTES_2500', nombre: 'TOTAL POSTES 2500', cantidad: getCantidad('POSTES_2500') },
            { codigo: 'LARGUERO_950', nombre: 'TOTAL LARGUERO 950', cantidad: getCantidad('LARGUERO_950') },
            { codigo: 'LARGUERO_ANTEPECHO_2930', nombre: 'TOTAL LARGUERO ANTEPECHO 2930', cantidad: getCantidad('LARGUERO_ANTEPECHO_2930') },
            { codigo: 'MAMPARA_964X2390', nombre: 'TOTAL MAMPARA 964 X 2390', cantidad: getCantidad('MAMPARA_964X2390') },
            { codigo: 'MAMPARA_ANTEPECHO_964X214', nombre: 'TOTAL PANEL ANTEPECHO 2944 X 214', cantidad: getCantidad('MAMPARA_ANTEPECHO_964X214') }
        ];
        agregarSeccion(contenedor, 'TOTALES STAND TIPO 3 (ANTEPECHO RECTO)', materialesFiltrados.map(m => ({ nombre: m.nombre, cantidad: m.cantidad })));
        
    } else if (tipoResultado === 'TIPO4') {
        materialesFiltrados = [
            { codigo: 'POSTES_2500', nombre: 'TOTAL POSTES 2500', cantidad: getCantidad('POSTES_2500') },
            { codigo: 'LARGUERO_950', nombre: 'TOTAL LARGUERO 950', cantidad: getCantidad('LARGUERO_950') },
            { codigo: 'MAMPARA_964X2390', nombre: 'TOTAL MAMPARA 964 X 2390', cantidad: getCantidad('MAMPARA_964X2390') },
            { codigo: 'MAMPARA_ANTEPECHO_CURVO_2400X300', nombre: 'TOTAL PANEL CON GANCHOS ANTEPECHO 2930 X 300', cantidad: getCantidad('MAMPARA_ANTEPECHO_CURVO_2400X300') }
        ];
        agregarSeccion(contenedor, 'TOTALES STAND TIPO 4 (ANTEPECHO RECTO DE PANEL ART CON GANCHOS)', materialesFiltrados.map(m => ({ nombre: m.nombre, cantidad: m.cantidad })));
    }
    
    // RETORNAR los materiales filtrados
    return materialesFiltrados;
}
